attribute vec2 coord;
uniform mat4 mvp;

#ifdef TEXTURE
attribute vec2 texcoord;
varying vec2 f_texcoord;
#endif

#ifdef HIGHLIGHT
attribute float highlight_factor;
varying float f_highlight_factor;
#endif

void main(void)
{
	gl_Position = mvp * vec4(coord.x, coord.y, 0.0, 1.0);

#ifdef TEXTURE
	f_texcoord = texcoord;
#endif

#ifdef HIGHLIGHT
	f_highlight_factor = highlight_factor;
#endif
}
